# Aerospike PHP Client Library v7 and older release notes

---

## PHP 7.5.2
Release Date: March 10, 2020 

### New Features
- Add OPT_SCAN_RPS_LIMIT scan option. OPT_SCAN_RPS_LIMIT limits scans by records per second. Thanks to [vityank](https://github.com/vityank).
- Add OPERATOR_DELETE. OPERATOR_DELETE allows deletion of entire records via operate and operateOrdered. Thanks to [vityank](https://github.com/vityank).
- Add NOBINS query option. Queries made with the NOBINS option will not return record's bins.

---

## PHP 7.4.2
Release Date: December 30, 2019 

### New Features
- **Breaking Change:** Switch to C client 4.6.0 consistency policies. Applications using previous PHP client versions should make changes according to the new [consistency policies](https://aerospike.com/docs/develop/client/c/incompatible#version-460---read-consistency-level-changes) and see the [docs](https://github.com/aerospike/aerospike-client-php/blob/master/doc/policies.md) when upgrading. Thanks to [vityank](https://github.com/vityank)
- **Breaking Change:** Discontinued support for PHP 7.1.
- Support PHP 7.2 and 7.3.
- Update to [C client 4.6.9](https://github.com/aerospike/aerospike-client-c/releases/tag/4.6.9).
- Added missing zend_arg_info. Thanks to [sustmi](https://github.com/sustmi)
- Add support for map write flags. Thanks to [vityank](https://github.com/vityank)
- Support C client error code [AEROSPIKE_ERR_OP_NOT_APPLICABLE](https://github.com/aerospike/aerospike-client-c/blob/8576a3396605bc3f2ca918f901b2afcb8c07638a/src/include/aerospike/as_status.h#L257).

---

## PHP 7.4.1
Release Date: February 20, 2019 

### New Features
- **Breaking Change:** Shared Memory layout has changed. Therefore the default SHM Key has changed from `0xA7000000` to `0xA8000000` _If you were specifying your own key, it is critical that this be updated for the use of client `7.4.1`_ .
- Removed the error constants `ERR_BIN_EXISTS`, `ERR_BIN_NOT_FOUND`.
- Update to [C client 4.5.0](https://github.com/aerospike/aerospike-client-c/releases/tag/4.5.0).
- Add Configuration options for Rack Aware reads.

---

## PHP 7.3.0
Release Date: November 14, 2018 

### New Features
- Update to [C client 4.3.20](https://github.com/aerospike/aerospike-client-c/releases/tag/4.3.20).
- Lua system files are now loaded from internal strings. The LUA_SYSTEM_PATH configuration options have been removed.
- **Breaking Change** Remove old use_batch_direct policy option.

### Bug Fixes
- Fix Syntax errors in Documentation file.

---

## PHP 7.2.0
Release Date: August 15, 2018 

### New Features
- Added support for TLS connections. See documentation for details. This is an enterprise only feature.
- Added new format for specifying policies in client constructor. This format allows the specification of default policies for,
  read, write, apply, query, batch, scan, operate, and remove operations.
- Exposed additional configuration options.
- Added a new method `errorInDoubt()` to check whether it is possible that an operation which resulted in error may have succeeded.
- Update to [C client 4.3.12](https://github.com/aerospike/aerospike-client-c/releases/tag/4.3.12).
- Add a policies.md file to the GitHub repository specifying information about all of the policies used with various methods.
- Improve installation on Debian 9 and Ubuntu 18.
- `queryApply` may now return before the query has completed.
- **Breaking Change** Shared memory layout has changed. The default SHM Key has changed from `0xA6000000` to `0xA7000000`.
- OPT_POLICY_RETRY has been replaced by OPT_MAX_RETRIES . Code using the former will not raise errors, but the option will
   be ignored.

### Bug Fixes
- Remove an unlisted/documented select method.
- Creating a matching index on an already indexed bin, or creating an index with an already used name will now return an Error instead of silently failing.
- Fix installation error on Debian 9.

---

## PHP 7.1.2
Release Date: April 05, 2018 

### Bug Fixes
- Prevent null pointer dereference during destructor use on invalid objects.

---

## PHP 7.1.0
Release Date: December 17, 2017 

### New Features
- Added new map operations:
   - AEROSPIKE::OP_MAP_SET_POLICY
   - AEROSPIKE::OP_MAP_CLEAR
   - AEROSPIKE::OP_MAP_SIZE
   - AEROSPIKE::OP_MAP_GET_BY_KEY
   - AEROSPIKE::OP_MAP_GET_BY_KEY_RANGE
   - AEROSPIKE::OP_MAP_GET_BY_VALUE
   - AEROSPIKE::OP_MAP_GET_BY_VALUE_RANGE
   - AEROSPIKE::OP_MAP_GET_BY_INDEX
   - AEROSPIKE::OP_MAP_GET_BY_INDEX_RANGE
   - AEROSPIKE::OP_MAP_GET_BY_RANK
   - AEROSPIKE::OP_MAP_GET_BY_RANK_RANGE
   - AEROSPIKE::OP_MAP_PUT
   - AEROSPIKE::OP_MAP_PUT_ITEMS
   - AEROSPIKE::OP_MAP_INCREMENT
   - AEROSPIKE::OP_MAP_DECREMENT
   - AEROSPIKE::OP_MAP_REMOVE_BY_KEY
   - AEROSPIKE::OP_MAP_REMOVE_BY_KEY_LIST
   - AEROSPIKE::OP_MAP_REMOVE_BY_KEY_RANGE
   - AEROSPIKE::OP_MAP_REMOVE_BY_VALUE
   - AEROSPIKE::OP_MAP_REMOVE_BY_VALUE_RANGE
   - AEROSPIKE::OP_MAP_REMOVE_BY_VALUE_LIST
   - AEROSPIKE::OP_MAP_REMOVE_BY_INDEX
   - AEROSPIKE::OP_MAP_REMOVE_BY_INDEX_RANGE
   - AEROSPIKE::OP_MAP_REMOVE_BY_RANK
   - AEROSPIKE::OP_MAP_REMOVE_BY_RANK_RANGE
- Switched documentation from Markdown to PHPDoc.

---

## PHP 7.0.4
Release Date: November 28, 2017 

### New Features
 - Enable specifying a TTL value for operate, operateOrdered, append, prepend, increment, listInsert, listInsertItems, listAppend, listMerge, listPop, listPopRange listRemove, listRemoveRange, listTrim, listClear, listSet methods via the AEROSPIKE::OPT_TTL field of the policy array.

### Bug Fixes
 - Specifying an incorrectly formatted AEROSPIKE::OPT_POLICY_GEN in a policy now returns an error code rather than silently ignoring the value.

---

## PHP 7.0.3
Release Date: November 09, 2017 

### New Features
 - Enable specifying interval for cluster tender in the constructor via the "tender_interval" config entry. See documentation for more details.
 - Enable specifying a cluster name in the constructor via the "cluster_name" config entry. See documentation for more details.

### Bug Fixes
 - Documentation: Expose class constants in PHPDoc stubs.
 - Documentation: Correct the name of the read write security privilege in the PHPDoc stub.

---

## PHP 7.0.2
Release Date: October 05, 2017 

### New Features
 - Enabled truncate functionality.
 - Improve installation experience for macOS.
 - Allow setting of socket_timeout via Aerospike::OPT_SOCKET_TIMEOUT in scan policies.
 - Improved setup script to allow installation on additional distros.

### Bug Fixes
 - Fix setting of timeout in remove policies.
 - Prevent null dereference in ZTS environments when using user specified logging during a cluster disruption.
 - Properly mark user specified logging as unsupported in ZTS environments.

---

## PHP 7.0.1
Release Date: September 14, 2017 

### Bug Fixes
 - Composer - Do not attempt to download PHPUnit.
 - Composer - Rename os_version script so permissions are set correctly.

---

## PHP 7.0.0
Release Date: September 12, 2017 

### New Features
 - Welcome to the new PHP7 Aerospike Client!
 - Incorporate PR 103 for session store. Thanks [@aterrien](https://github.com/aterrien)!
 - LDT Support has been removed.
 - Type checking in general is stricter for method parameters. If you are not sure whether an argument to a function is an integer or a string, we recommend casting it to the type specified by the method. Running with strict_types enabled may help to catch some issues.
 - An exception will be raised if the constructor fails to connect to the cluster.
 - Aerospike\Bytes will be stored to the server as type AS_BYTES_BLOB instead of AS_BYTES_PHP. This change allows better compatability with other clients.
 - Correspondingly, data stored in the server as AS_BYTES_BLOB will be returned as Aerospike\Bytes, if no deserializer has been registered. The Previous version of the Aerospike PHP Client returned a string if AS_BYTES_BLOB was encountered with no registered deserializer. Note It is not recommended to combine the use of \Aerospike\Bytes and user specified deserializers, as this may cause errors.
 - Support for PHP versions < 7 has been removed.
 - The INI entry aerospike.serializer now takes an integer value. 0 for No Serializer, 1 for default PHP serialization, and 2 for user specified serializer. See Configuration for additional information on the code values.
 - The constructor will no longer attempt to create a unique SHM key for the user. If a key is not specified in the shm configuration array, the default value will be used. A key provided in the constructor takes precedence over a value specified by INI.
 - The layout of the shared memory used by the client when using an SHM key has changed. The default key has changed as well in order to prevent accidental sharing between new and old clients.
 - The formatting of the response from an info call may have changed. It now includes the request at the beginning of the response.
 - When using initKey with a digest, the digest must now be exactly 20 bytes.
 - The integer values of the Aerospike::LOG_LEVEL_* constants have changed. This should not effect the user unless they were providing log levels as integers rather than using the constants.
 - Aerospike::LOG_LEVEL_OFF has been removed. It no longer had any effect.

---

## PHP 3.4.14
Release Date: January 04, 2017 

### Bug Fixes
 - Fix persistent connection issue under php-fpm which caused number of threads to increase.
 - Fix shared memory persistence under php-fpm.
 - Fix segfault in Aerospike constructor if cluster is NULL.
 - Roll in PRs #129, #133 & #134 from the community. Thanks [@koleo](https://github.com/koleo) & [@sergeyklay](https://github.com/sergeyklay)!

---

## PHP 3.4.13
Release Date: November 17, 2016 

### Bug Fixes
 - Fix segfault in PHP7 when using php-fpm.

---

## PHP 3.4.12
Release Date: November 04, 2016 

### Bug Fixes
 - Roll in PRs #120, #121 & #125 from the community. Thanks [@koleo](https://github.com/koleo)!

---

## PHP 3.4.11
Release Date: September 29, 2016 

### New Features
 - Added support for durable delete (requires EE server version v3.10+).

### Bug Fixes
 - Fix seg fault in PHP7 when using persistent connections and/or multiple hosts in configuration. [CLIENT-789]
 - Use correct C client bits for various Ubuntu builds. [CLIENT-737]
 - Fix aggregate for PHP7.
 - Roll in several PR's from the community. Thanks [@sergeyklay](https://github.com/sergeyklay), @devckonem & [@dink10](https://github.com/dink10)!

---

## PHP 3.4.10
Release Date: September 08, 2016 

### Bug Fixes
 - Restore backward compatibility to session handler. Thanks [@koleo](https://github.com/koleo)!
 - Fix increment using floating point values.
 - Use correct C client bits for various Ubuntu builds.
 - Update to [C client 4.0.7](https://github.com/aerospike/aerospike-client-c/releases/tag/4.0.7).
 - Fix seg fault when configuration has "shm" option.
 - Update composer.json to reflect PHP7 support.

---

## PHP 3.4.9
Release Date: July 28, 2016 

### New Features
 - Initial support for PHP 7.

### Bug Fixes
 - Incorporate PR 103 for session store. Thanks [@aterrien](https://github.com/aterrien)!

---

## PHP 3.4.8
Release Date: April 08, 2016 

### New Features
 - Added Aerospike::operateOrdered API which takes the same parameters as Aerospike::operate but returns an indexed array of results, rather than a key-value associative array. [CLIENT-652]
 - Added support for Geospatial index using GeoJSON. [CLIENT-542] **Requires server >= 3.7.0**

### Bug Fixes
 - Use session.gc_maxlifetime for the session timeout (was session.cache_expire). [CLIENT-705]

---

## PHP 3.4.7
Release Date: March 05, 2016 

### New Features
 - Upgraded to [C client 4.0.2](https://github.com/aerospike/aerospike-client-c/releases/tag/4.0.2).
 - Added [list operations](https://github.com/citrusleaf/aerospike-client-php/blob/master/doc/apiref_kv.md). [CLIENT-561] **Requires server >= 3.7.0**
 - Added list operators for operate(). [CLIENT-646] **Requires server >= 3.7.0**
 - isConnected() now testing the client's connections to the nodes. [CLIENT-624]
 - Allow the Aerospike class to be extendable. [CLIENT-648]
 - Added a compression_threshold client config parameter. [CLIENT-627]
 - Added OPT_SCAN_INCLUDELDT option for scan(). [CLIENT-610]

---

## PHP 3.4.6
Release Date: December 25, 2015 

### New Features
 - Secondary-index record UDFs using queryApply(). [CLIENT-299]
 - Enable shared-memory cluster tending through the constructor config. [CLIENT-595]
 - Added the config params max\_threads, thread\_pool\_size. [CLIENT-296]
 - Removed the deprecated method createIndex(). Use addIndex(). [CLIENT-585]
 - Cleaned up the client [documentation](https://github.com/aerospike/aerospike-client-php/blob/master/doc/README.md). Thanks [@sergeyklay](https://github.com/sergeyklay) for your help.

### Bug Fixes
 - Fixed shared-memory cluster tending by generating a unique shm key per-hostname. [CLIENT-9]
 - Fixed Issue 62. [CLIENT-596]

---

## PHP 3.4.5
Release Date: November 03, 2015 

### Bug Fixes
 - Fixed a memory leak in batch read operations. [CLIENT-568]

---

## PHP 3.4.4
Release Date: October 30, 2015 

### New Features
 - Added explicit control over the [batch protocol](https://aerospike.com/docs/develop/learn/batch) through a php.ini config variable aerospike.use\_batch\_direct, or constructor config parameter Aerospike::USE\_BATCH\_DIRECT. The default value is 0 (i.e. _batch-index_) for servers with **version >=  3.6.0**. [CLIENT-567]
 - Added support for Ubuntu 15. Thanks [@lwille](https://github.com/lwille).

---

## PHP 3.4.3
Release Date: October 22, 2015 

### New Features
 - Upgraded to [C client 3.1.24](https://github.com/aerospike/aerospike-client-c/releases/tag/3.1.24).
 - A new **backward incompatible** format for the data returned by existsMany(). The underlying C client interfaces with a new API for batch reads called [batch index](https://aerospike.com/docs/develop/learn/batch/), which is implemented in server versions **>= 3.6.0**. Since batch reads can now target multiple namespaces, the old format is no longer appropriate. Instead, an indexed array is returned in an order corresponding to the array of keys passed as the argument to existsMany().  [CLIENT-28]
 - Allow TTL to be set with the write methods increment(), append(), prepend(), operate(), removeBin() using OPT\_TTL. [CLIENT-510]
 - Updated the methods of class LList. Added filters to find, findFirst, findLast, findRange.
 - Expanded the examples for LList with integer, string, and map elements.
 - Removed deprecated LDT classes (LMap, LSet, LStack) and methods.
 - Fixed the documentation for the Enterprise Edition security methods.
 - Fixed the installer to place the Lua system files in /usr/local/aerospike/lua by default. Path override can be done by setting the environment variables LUA\_SYSPATH, LUA\_USRPATH before invoking build.sh.
 - Travis-CI cleanup.

### Bug Fixes
 - Fixed bug where malformed keys triggered a segfault in getMany(). [CLIENT-140] / [AER-4342]
 - Fixed the client to cast PHP floats to and from as\_double. [CLIENT-225]
 - Fixed Issue - correct configuration inheritance. [CLIENT-88]
 - Fixed Issue - return the correct error status for empty put(). [CLIENT-69]
 - Fixed Issue - incorrectly identifying RHEL. Thanks, [@npenteado](https://github.com/npenteado).

---

## PHP 3.4.2
Release Date: September 03, 2015 

### New Features
 - Upgraded to [C client 3.1.22](https://github.com/aerospike/aerospike-client-c/releases/tag/3.1.22). [AER-3909]
 - A new **backward incompatible** format for the data returned by getMany(). The underlying C client interfaces with a new API for batch reads called [batch index](https://aerospike.com/docs/develop/learn/batch/), which is implemented in server versions **>= 3.6.0**. Since batch reads can now target multiple namespaces, the old format is no longer appropriate. Instead, an indexed array is returned in an order corresponding to the array of keys passed as the argument to getMany().  [AER-4064]
 - Tests and API documentation updated. Thanks to [@rmondragon](https://github.com/rmondragon) for his help.

---

## PHP 3.4.1
Release Date: August 09, 2015 

### New Features
 - Added Security Methods for [Aerospike Monitoring Console](https://github.com/aerospike-community/amc). [AER-3475]
 - Added support for Debian 8.
 - Clarified configuration steps for the activating the extension with web servers, such as Nginx and Apache. Thanks Mickael Hassine.

### Bug Fixes
 - Fixed case where scan aggregations caused the scan jobs to hang. [AER-3813]

---

## PHP 3.4.0
Release Date: July 20, 2015 

### New Features
 - Support for `null` as valid argument to a UDF. [AER-4003]
 - Prefer to always download the appropriate C client ahead of building the extension. [AER-4001]

### Bug Fixes
 - Fixed Issue - a new **backward incompatible** format for data returned by aggregate(). [AER-3948] Thanks [@arussellsaw](https://github.com/arussellsaw).

---

## PHP 3.3.16
Release Date: June 19, 2015 

### New Features
 - Added an optional ttl argument to Aerospike::OPERATOR_TOUCH in operate().  [AER-3566]
 - Copy registered modules to user path in register(). [AER-3627]
 - Changes to LList, added isValid(), findRange(), setPageSize(). Modified scan() in a *compatibility breaking* way.

### Bug Fixes
 - Fixed Issue - reusing keys from scan/query. [AER-3748]
 - Fixed Issue - accept numeric strings for increment(). [AER-3812]
 - Fixed bug preventing a default value of 'user' for serializer. [AER-3527]
 - Partially fixed Issue - bigger static allocation for as\_val. [AER-3708]
 - Expanded checks for libcrypto. Thanks @jumping

---

## PHP 3.3.15
Release Date: May 04, 2015 

### New Features
 - Upgraded to [C client 3.1.16](https://github.com/aerospike/aerospike-client-c/releases/tag/3.1.16).
 - Added support for indexing complex types (lists, map) and for querying against those secondary indexes using the contains and range predicates. Those will become fully available with a near-future release of Aerospike server.  [AER-3425],  [AER-3434]

### Bug Fixes
 - Fixed to allow OPT\_SERIALIZER to be set to SERIALIZER\_USER in an apply() call. [AER-3528]

---

## PHP 3.3.14
Release Date: April 26, 2015 

### New Features
 - Implemented authentication in support of the Enterprise edition of Aerospike Issue. [AER-3551]
 - Slight clean-up of the doc and examples.

### Bug Fixes
 - Making sure the bin-name length limit is 14, not 13. [AER-3571]

---

## PHP 3.3.13
Release Date: April 18, 2015 

### New Features
 - Implemented configuration globals through the constructor.
 - Added support for namespaces with a null set in index creation, scan() and query().
 - A [Aerospike\Bytes](https://github.com/aerospike/aerospike-client-php/blob/master/src/Bytes.php) wrapper added, and doc updated regarding the [handling of binary-strings](https://github.com/aerospike/aerospike-client-php/blob/master/doc/README.md#handling-unsupported-types) that may contain the null-byte (**\0**).
 - LList Deprecated get_capacity(),set_capacity() methods of the LDT parent class.
 - LList added methods find_first, find_last, find_range, exists, config, setPageSize. **Require server >= 3.5.8**

### Bug Fixes
 - Fixed Issue for non-ZTS PHP, still in progress for the other case.

---

## PHP 3.3.12
Release Date: April 03, 2015 

### New Features
 - Upgraded to [C client 3.1.11](https://github.com/aerospike/aerospike-client-c/releases/tag/3.1.11).

### Bug Fixes
 - Fixed Issue 35.

---

## PHP 3.3.11
Release Date: March 05, 2015 

### New Features
 - Upgraded to [C client 3.1.8](https://github.com/aerospike/aerospike-client-c/releases/tag/3.1.8).
 - Support for generation policies in remove(). **Requires server version >= 3.5.3**

### Bug Fixes
 - Fixed Issue - The increment() method is **modified** to reflect the behavior of the C client (aka _upsert_).

---

## PHP 3.3.10
Release Date: February 25, 2015 

### New Features
 - Upgraded to [C client 3.1.2](https://github.com/aerospike/aerospike-client-c/releases/tag/3.1.2).
 - Removed dependency on Lua as a prerequisite.
 - Added Aerospike::getKeyDigest().
 - Upgrades to LList `update()`, `update_all()`, UDF filter arguments for `scan()`, `llist.filter` wrapped into `scan()`,  `removeRange()` implements `llist.remove_range`, `llist.remove_all` implemented as `removeMany()`.
 - LDT Deprecation notice for LMap, LSet, LStack.
 - Enhanced the [docs](https://github.com/aerospike/aerospike-client-php/blob/master/doc/README.md) and [examples](https://github.com/aerospike/aerospike-client-php/tree/master/examples).

### Bug Fixes
 - Fixed Issue 16.
 - Fixed Issue 22.
 - Fixed Issue 9.

---

## PHP 3.3.9
Release Date: February 04, 2015 

### Bug Fixes
 - Fixed a memory leak in the increment() method.

---

## PHP 3.3.8
Release Date: January 28, 2015 

### Bug Fixes
 - Fixed Issue 11.

---

## PHP 3.3.7
Release Date: January 22, 2015 

### Bug Fixes
 - Fixed Issue 17.

---

## PHP 3.3.6
Release Date: January 15, 2015 

### New Features
 - Documentation for bin operations clarified.
 - Removed mention of deprecated status ERR_BIN_TYPE from the docs.
 - Added a [multi-process performance testing script](https://github.com/aerospike/aerospike-client-php/tree/master/examples/performance).

### Bug Fixes
 - Fixed Issue 14.

---

## PHP 3.3.5
Release Date: January 09, 2015 

### New Features
  - Upgraded to [C client 3.0.94](https://github.com/aerospike/aerospike-client-c/releases/tag/3.0.94).
  - Faster close() resulting in faster tests and session handling.
  - Fixed script that fetches the C client to work with minimal CentOS 7.
  - Added support for queries without a predicate.

---

## PHP 3.3.4
Release Date: December 29, 2014 

### New Features
  - Fixed a bug with default serialization of unsupported types (boolean, float, etc).
  - Added support for Linux Mint.

---

## PHP 3.3.3
Release Date: December 24, 2014 

### New Features
  - Support for Per-transaction consistency guarantees OPT\_POLICY\_COMMIT\_LEVEL, OPT\_POLICY\_REPLICA, OPT\_POLICY\_CONSISTENCY.
  - Fixes Issue 8.
  - createIndex(), register() now wait till operation is confirmed by the server.
  - Added LDT examples.

---

## PHP 3.3.2
Release Date: December 05, 2014 

### New Features
  - Aerospike session handler for PHP sessions.
  - Issue 7 fixed.

---

## PHP 3.3.1
Release Date: November 26, 2014 

### New Features
  - Shared-memory cluster tending. Load is reduced when multiple PHP processes can share the data from a single tending thread.
  - Upgraded to [C client 3.0.90](https://github.com/aerospike/aerospike-client-c/releases/tag/3.0.90).
  - Reorganized the unit tests to run faster.
  - Removed deprecated status codes ERR (now it’s just ERR_CLIENT), ERR_RECORD, ERR_THROTTLED, ERR_SCAN, ERR_UDF_FILE_NOT_FOUND.

---

## PHP 3.3.0
Release Date: October 30, 2014 

### New Features
  - Batch operations - getMany() and existsMany().
  - Multi-op record operations - operate().
  - Compilation error fixed for OS X >= 10.9 (also tested on 10.10 "Yosemite")).
  - Upgraded to [C client 3.0.86](https://github.com/aerospike/aerospike-client-c/releases/tag/3.0.86).

---

## PHP 3.2.1
Release Date: October 24, 2014 

### New Features
  - Examples cleaned up.
  - Fixed digest key bug.

---

## PHP 3.2.0
Release Date: October 22, 2014 

### New Features
  - Admin methods createIndex() and dropIndex().
  - Info methods info(), infoMany(), getNodes().
  - Write methods support OPT_POLICY_GEN.

---

## PHP 3.1.1
Release Date: October 07, 2014 

### New Features
  - Starting version >= 3.1.0 - **format change for returned records** now all records come back as an array with keys ('key','meta','bins').
  - Set the [C client 3.0.84](https://github.com/aerospike/aerospike-client-c/releases/tag/3.0.84) (latest stable).
  - Methods get(), put() fixed to support OPT_POLICY_KEY.
  - Fixed apply() for case when the $returned parameter is not set.
  - Fixes to the .phpt tests.

---

## PHP 3.1.0
Release Date: October 07, 2014 

### New Features
  - A **format change for returned records** now all records come back as an array with keys ('key','meta','bins').  **Your applicaiton will need to be recoded** to account for this change, as it is not backward compatible.
  - OPT_POLICY_KEY added for read and write methods.
  - Support for Large Data Types with a PHP class library \Aerospike\LDT.
  - Added stream UDF methods scanApply() and aggregate().
  - UDF module admin methods register(), deregister(), listRegistered(), getRegistered().
  - Background scan method scanApply() with OPT\_SCAN\_* policies to control its behavior and scanInfo() helper.
  - Standardized (and therefore modified) parameter lists for stream methods - query(), scan(), aggregate(), scanApply().
  - Fixes for FPM and APXS SAPIs.
  - Extension is now built with *src/aerospike/build.sh*.
  - Composer support.
  - Integration with Travis CI.

---

## PHP 3.0.3
Release Date: September 11, 2014 

### New Features
   - Fixed apply() argument list.
   - Enhanced build script with install & config instructions.

---

## PHP 3.0.2
Release Date: September 05, 2014 

### New Features
   - Works with PHP versions 5.3 - 5.6.
   - Record UDF & UDF management methods.
   - Example scripts.

---

## PHP 3.0.1
Release Date: August 27, 2014 

### New Features
   - Initial 3.0 client release.
   - Lifecycle and connection methods.
   - Key-Value methods.
   - Query and Scan methods.

---

## PHP 2.1.37
Release Date: June 10, 2014 

### Bug Fixes
   - Adding warning suppression to string hostlist function. [AER-1601]
   - Put correct include path for some examples.
